package gg.now.nowggsdkdemo;

import android.content.Intent;
import android.os.Bundle;
import android.widget.Button;

import androidx.appcompat.app.AppCompatActivity;

import gg.now.nowggsdkdemo.events.EventsManagerActivity;

import gg.now.nowggsdkdemo.login.LoginActivity;
import gg.now.nowggsdkdemo.payments.BillingActivity;
import gg.now.nowggsdkdemo.rewardedAds.RewardedAdsActivity;
import gg.now.nowggsdkdemo.utility.UtilityActivity;

public class MainActivity extends AppCompatActivity {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        bindButtonToActivity(R.id.btnOpenPaymentsDemo, BillingActivity.class);
        bindButtonToActivity(R.id.btnOpenLoginDemo, LoginActivity.class);
        bindButtonToActivity(R.id.btnOpenEventsManagerDemo, EventsManagerActivity.class);
        bindButtonToActivity(R.id.btnOpenRewardedAdsDemo, RewardedAdsActivity.class);
        bindButtonToActivity(R.id.btnOpenUtilityDemo, UtilityActivity.class);
    }

    private void bindButtonToActivity(int buttonId, Class<?> targetActivity) {
        Button btn = findViewById(buttonId);
        btn.setOnClickListener(v -> {
            Intent intent = new Intent(this, targetActivity);
            startActivity(intent);
        });
    }
}
