package gg.now.nowggsdkdemo.events;

import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;

import androidx.appcompat.app.AppCompatActivity;

import gg.now.eventsmanager.NowGGEventCallback;
import gg.now.eventsmanager.NowGGEventsSdkManager;
import gg.now.nowggsdkdemo.R;

public class EventsManagerActivity extends AppCompatActivity {

    private String TAG = "MainActivity";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main_events_manager);

        findViewById(R.id.openUrl).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                String url = ((EditText) (findViewById(R.id.urlEditText))).getText().toString();
                if (url.equals("")) {
                    url = "https://now.gg";
                }
                NowGGEventsSdkManager.getInstance().openUrl(url, EventsManagerActivity.this);
            }
        });

        findViewById(R.id.sendEventToBrowser).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                NowGGEventsSdkManager.getInstance().sendEventToBrowser("sample_event_name", "sample_event_data", EventsManagerActivity.this);
            }
        });

        findViewById(R.id.getAppLaunchDataProperty).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                String property = NowGGEventsSdkManager.getInstance().getAppLaunchDataProperty("event_name", EventsManagerActivity.this);
                Toast.makeText(EventsManagerActivity.this, property, Toast.LENGTH_LONG).show();
            }
        });

        findViewById(R.id.getAppLaunchDataDictionary).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                Bundle bundle = NowGGEventsSdkManager.getInstance().getAppLaunchDataBundle(EventsManagerActivity.this);
                StringBuilder stringBuilder = new StringBuilder();
                for (String key : bundle.keySet()) {
                    stringBuilder.append(key).append(" : ").append(bundle.get(key)).append("\n");
                }
                Log.d(TAG, "extras : " + stringBuilder.toString());
                Toast.makeText(EventsManagerActivity.this, stringBuilder.toString(), Toast.LENGTH_LONG).show();
            }
        });

        TextView textView = findViewById(R.id.eventDataTextView);

        NowGGEventCallback eventCallback = (String eventName, String eventData) -> {
            textView.setText(String.format("EventName: %s\nEventData: %s", eventName, eventData));
        };

        NowGGEventsSdkManager.getInstance().registerEventListener(this,eventCallback);

    }


    @Override
    public void onDestroy(){
        NowGGEventsSdkManager.getInstance().unregisterEventListener(this);
        super.onDestroy();
    }
}