package gg.now.nowggsdkdemo.payments;

import static gg.now.nowggsdkdemo.payments.billing.BillingManager.BILLING_MANAGER_NOT_INITIALIZED;

import android.app.AlertDialog;
import android.os.Bundle;
import android.os.Looper;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.Switch;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.annotation.UiThread;
import androidx.appcompat.app.AppCompatActivity;

import gg.now.billingclient.api.BillingClient;
import gg.now.nowggsdkdemo.R;
import gg.now.nowggsdkdemo.payments.billing.BillingManager;
import gg.now.nowggsdkdemo.payments.billing.BillingProvider;
import gg.now.nowggsdkdemo.payments.skulist.AcquireFragment;
import gg.now.nowggsdkdemo.payments.skulist.row.DiamondsDelegate;
import gg.now.nowggsdkdemo.payments.skulist.row.StarterPackageDelegate;
import gg.now.nowggsdkdemo.payments.skulist.row.SwordDelegate;
import gg.now.nowggsdkdemo.payments.skulist.row.VIPMonthlyDelegate;
import gg.now.billingclient.BuildConfig;

public class BillingActivity extends AppCompatActivity implements BillingProvider {
    private static final String TAG = "payments";
    public Button button_open_store, button_send_event, init_payment;
    private ImageView imageView_vip, imageView_sword, imageView_package, imageView_diamonds;

    private TextView state_vip, state_sword, state_package, state_diamonds, tv_quantity_sword, tv_quantity_package, tv_quantity_diamonds;
    private BillingManager mBillingManager;
    private AcquireFragment mAcquireFragment;
    private MainViewController mViewController;
    private View mScreenWait;

    private boolean isBillingManagerInitialized = false;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main_billing);

        button_open_store = findViewById(R.id.button_open_store);
        mScreenWait = findViewById(R.id.screen_wait);
        imageView_vip = findViewById(R.id.imageView_vip);
        imageView_sword = findViewById(R.id.imageView_sword);
        imageView_package = findViewById(R.id.imageView_package);
        imageView_diamonds = findViewById(R.id.imageView_diamonds);
        state_vip = findViewById(R.id.state_vip);
        state_sword = findViewById(R.id.state_sword);
        state_package = findViewById(R.id.state_package);
        state_diamonds = findViewById(R.id.state_diamonds);
        tv_quantity_sword = findViewById(R.id.tv_quantity_sword);
        tv_quantity_package = findViewById(R.id.tv_quantity_package);
        tv_quantity_diamonds = findViewById(R.id.tv_quantity_diamonds);

        button_send_event = findViewById(R.id.button_sdk_event);
        init_payment = findViewById(R.id.button_init_payment);

        imageView_sword.setOnClickListener(v -> {
            mBillingManager.initiatePurchaseFlow(SwordDelegate.SKU_ID, BillingClient.SkuType.INAPP, "dev payload");
        });
        imageView_package.setOnClickListener(v -> {
            mBillingManager.initiatePurchaseFlow(StarterPackageDelegate.SKU_ID, BillingClient.SkuType.INAPP, "dev payload");
        });
        imageView_diamonds.setOnClickListener(v -> {
            mBillingManager.initiatePurchaseFlow(DiamondsDelegate.SKU_ID, BillingClient.SkuType.INAPP, "dev payload");
        });
        imageView_vip.setOnClickListener(v -> {
            mBillingManager.initiatePurchaseFlow(VIPMonthlyDelegate.SKU_ID, BillingClient.SkuType.SUBS, "dev payload");
        });

        TextView tv_version = findViewById(R.id.tv_version);
        tv_version.setText(BuildConfig.BILLING_CLIENT_VERSION_NAME);

        setWaitScreen(false);

        // Start the controller and load game data
        mViewController = new MainViewController(BillingActivity.this);

        if(savedInstanceState != null) {
            isBillingManagerInitialized = savedInstanceState.getBoolean("isBillingManagerInitialized", false);
            if (isBillingManagerInitialized) {
                Log.i(TAG, "Restoring existing BillingManager");
                initBillingManager();
            }
        }

        init_payment.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                initBillingManager();
            }
        });

        button_open_store.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onOpenStoreButtonClicked(v);
            }
        });

        findViewById(R.id.button_exit).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                finish();
            }
        });

        button_send_event.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                BillingClient.recordGameEvent(getApplicationContext(), "demo_event_name", "data", null);
            }
        });

        updateUi();
    }

    @Override
    protected void onResume() {
        super.onResume();
        // Note: We query purchases in onResume() to handle purchases completed while the activity
        // is inactive. For example, this can happen if the activity is destroyed during the
        // purchase flow. This ensures that when the activity is resumed it reflects the user's
        // current purchases.
//        if (mBillingManager != null
//                && mBillingManager.getBillingClientResponseCode() == BillingClient.BillingResponse.OK) {
//            // make sure this run after init.
//            mBillingManager.queryPurchasesAsync();
//        }
    }

    @Override
    public void onDestroy() {
        Log.i(TAG, "Destroying helper.");
        if (mBillingManager != null) {
            mBillingManager.destroy();
        }
        super.onDestroy();
    }

    /**
     * Remove loading spinner and refresh the UI
     */
    public void showRefreshedUi() {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                setWaitScreen(false);
                updateUi();
                if (mAcquireFragment != null) {
                    mAcquireFragment.refreshUI();
                }
            }
        });
    }

    /**
     * Update UI to reflect model
     */
    @UiThread
    private void updateUi() {
        Log.i(TAG, "Updating the UI. Thread: " + Thread.currentThread().getName());
        imageView_vip.setImageResource(isVIPMonthlySubscribed() ? R.drawable.vip_icon : R.drawable.vip_icon_gray);
        state_vip.setText(isVIPMonthlySubscribed() ? "owned" : "not owned");
        imageView_sword.setImageResource(isSwordPurchased() ? R.drawable.sword_icon : R.drawable.sword_icon_gray);
        state_sword.setText(isSwordPurchased() ? "owned" : "not owned");
        tv_quantity_sword.setText(String.valueOf(mViewController.getQuantityOfSwords()));
        imageView_package.setImageResource(isPackagePurchased() ? R.drawable.starter_package_icon : R.drawable.starter_package_icon_gray);
        state_package.setText(isPackagePurchased() ? "owned" : "not owned");
        tv_quantity_package.setText(String.valueOf(mViewController.getQuantityOfPackages()));
        imageView_diamonds.setImageResource(isDiamondsPurchased() ? R.drawable.diamonds_icon : R.drawable.diamonds_icon_gray);
        state_diamonds.setText(isDiamondsPurchased() ? "owned" : "not owned");
        tv_quantity_diamonds.setText(String.valueOf(mViewController.getQuantityOfDiamonds()));
    }

    /**
     * Enables or disables the "please wait" screen.
     */
    private void setWaitScreen(boolean set) {
        mScreenWait.setVisibility(set ? View.VISIBLE : View.GONE);
    }

    public void onOpenStoreButtonClicked(final View arg0) {
        Log.i(TAG, "open store button clicked.");

        if (mAcquireFragment == null) {
            mAcquireFragment = new AcquireFragment();
        }

        if (!isAcquireFragmentShown()) {
            mAcquireFragment.show(getSupportFragmentManager(), "");

            if (mBillingManager != null
                    && mBillingManager.getBillingClientResponseCode()
                    > BILLING_MANAGER_NOT_INITIALIZED) {
                mAcquireFragment.onManagerReady(this);
            }
        }
    }

    void onBillingManagerSetupFinished() {
        setWaitScreen(false);
        if (mAcquireFragment != null) {
            mAcquireFragment.onManagerReady(this);
        }
    }

    public boolean isAcquireFragmentShown() {
        return mAcquireFragment != null && mAcquireFragment.isVisible();
    }

    @Override
    public BillingManager getBillingManager() {
        return mBillingManager;
    }

    @Override
    public boolean isSwordPurchased() {
        return mViewController.isSwordPurchased();
    }

    @Override
    public boolean isPackagePurchased() {
        return mViewController.isPackagePurchased();
    }

    @Override
    public boolean isDiamondsPurchased() {
        return mViewController.isDiamondsPurchased();
    }

    @Override
    public boolean isVIPMonthlySubscribed() {
        return mViewController.isVIPMonthlySubscribed();
    }

    /**
     * Show an alert dialog to the user
     *
     * @param messageId     String id to display inside the alert dialog
     * @param optionalParam Optional attribute for the string
     */
    @UiThread
    void alert(@StringRes int messageId, @Nullable Object optionalParam) {
        if (Looper.getMainLooper().getThread() != Thread.currentThread()) {
            throw new RuntimeException("Dialog could be shown only from the main thread");
        }

        AlertDialog.Builder bld = new AlertDialog.Builder(this);
        bld.setNeutralButton("OK", null);

        if (optionalParam == null) {
            bld.setMessage(messageId);
        } else {
            bld.setMessage(getResources().getString(messageId, optionalParam));
        }

        bld.create().show();
    }


    @Override
    protected void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putBoolean("isBillingManagerInitialized", isBillingManagerInitialized);
        Log.i(TAG, "onSaveInstanceState, setting isBillingManagerInitialized to " + isBillingManagerInitialized);
    }

    private void initBillingManager() {
        setWaitScreen(true);
        mBillingManager = new BillingManager(BillingActivity.this, mViewController.getUpdateListener());
        isBillingManagerInitialized = true;
    }

}