package gg.now.nowggsdkdemo.payments.skulist.row;

import gg.now.billingclient.api.BillingClient.SkuType;
import gg.now.nowggsdkdemo.R;
import gg.now.nowggsdkdemo.payments.billing.BillingProvider;

/**
 * Handles Ui specific to "10_diamonds" - consumable in-app purchase row
 */
public class DiamondsDelegate extends UiManagingDelegate {
    public static final String SKU_ID = "coin_1000";

    public DiamondsDelegate(BillingProvider billingProvider) {
        super(billingProvider);
    }

    @Override
    public @SkuType
    String getType() {
        return SkuType.INAPP;
    }

    @Override
    public void onBindViewHolder(SkuRowData data, RowViewHolder holder) {
        super.onBindViewHolder(data, holder);
        holder.button.setText(R.string.button_buy);
        holder.skuIcon.setImageResource(R.drawable.diamonds_icon);
    }

    @Override
    public void onButtonClicked(SkuRowData data) {
        super.onButtonClicked(data);
    }
}

