package gg.now.nowggsdkdemo.payments.skulist.row;

import gg.now.billingclient.api.BillingClient.SkuType;
import gg.now.billingclient.api.ProductDetails;
import gg.now.nowggsdkdemo.payments.skulist.SkusAdapter;

/**
 * A model for SkusAdapter's row
 */
public class SkuRowData {
    private String sku, title, price, description, currency;
    private @SkusAdapter.RowTypeDef
    int type;
    private @SkuType
    String billingType;

    public SkuRowData(ProductDetails details, @SkusAdapter.RowTypeDef int rowType,
                      @SkuType String billingType) {
        this.sku = details.getProductId();
        this.title = details.getTitle();
        this.price = details.getOneTimePurchaseOfferDetails() != null ?
                details.getOneTimePurchaseOfferDetails().getFormattedPrice() :  details.getPricingPhase().getFormattedPrice();
        this.currency = details.getOneTimePurchaseOfferDetails() != null ? details.getOneTimePurchaseOfferDetails().getPriceCurrencyCode() : details.getPricingPhase().getPriceCurrencyCode();
        this.description = details.getDescription();
        this.type = rowType;
        this.billingType = billingType;
    }

    public SkuRowData(String title) {
        this.title = title;
        this.type = SkusAdapter.TYPE_HEADER;
    }

    public String getSku() {
        return sku;
    }

    public String getTitle() {
        return title;
    }

    public String getPrice() {
        return price;
    }

    public String getCurrency() {
        return currency;
    }

    public String getDescription() {
        return description;
    }

    public @SkusAdapter.RowTypeDef
    int getRowType() {
        return type;
    }

    public @SkuType
    String getSkuType() {
        return billingType;
    }
}
