package gg.now.nowggsdkdemo.payments.skulist.row;

import gg.now.billingclient.api.BillingClient.SkuType;
import gg.now.nowggsdkdemo.R;
import gg.now.nowggsdkdemo.payments.billing.BillingProvider;

/**
 * Handles Ui specific to "premium" - consumable in-app item row
 */
public class StarterPackageDelegate extends UiManagingDelegate {
    public static final String SKU_ID = "coin_2000";

    public StarterPackageDelegate(BillingProvider billingProvider) {
        super(billingProvider);
    }

    @Override
    public @SkuType
    String getType() {
        return SkuType.INAPP;
    }

    @Override
    public void onBindViewHolder(SkuRowData data, RowViewHolder holder) {
        super.onBindViewHolder(data, holder);
        int textId = R.string.button_buy;
        holder.button.setText(textId);
        holder.skuIcon.setImageResource(R.drawable.starter_package_icon);
    }

    @Override
    public void onButtonClicked(SkuRowData data) {
        super.onButtonClicked(data);
    }
}
