package gg.now.nowggsdkdemo.payments.skulist.row;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import gg.now.billingclient.api.BillingClient.SkuType;
import gg.now.nowggsdkdemo.payments.billing.BillingProvider;

/**
 * This factory is responsible to finding the appropriate delegate for Ui rendering and calling
 * corresponding method on it.
 */
public class UiDelegatesFactory {
    private final Map<String, UiManagingDelegate> uiDelegates;

    public UiDelegatesFactory(BillingProvider provider) {
        uiDelegates = new HashMap<>();
        uiDelegates.put(SwordDelegate.SKU_ID, new SwordDelegate(provider));
        uiDelegates.put(StarterPackageDelegate.SKU_ID, new StarterPackageDelegate(provider));
        uiDelegates.put(DiamondsDelegate.SKU_ID, new DiamondsDelegate(provider));
        // uiDelegates.put(VIPMonthlyDelegate.SKU_ID, new VIPMonthlyDelegate(provider));
    }

    /**
     * Returns the list of all SKUs for the billing type specified
     */
    public final List<String> getSkuList(@SkuType String billingType) {
        List<String> result = new ArrayList<>();
        for (String skuId : uiDelegates.keySet()) {
            UiManagingDelegate delegate = uiDelegates.get(skuId);
            if (delegate.getType().equals(billingType)) {
                result.add(skuId);
            }
        }
        return result;
    }

    public void onBindViewHolder(SkuRowData data, RowViewHolder holder) {
        uiDelegates.get(data.getSku()).onBindViewHolder(data, holder);
    }

    public void onButtonClicked(SkuRowData data) {
        uiDelegates.get(data.getSku()).onButtonClicked(data);
    }
}
