package gg.now.nowggsdkdemo.payments.skulist.row;

import gg.now.billingclient.api.BillingClient.SkuType;
import gg.now.nowggsdkdemo.R;
import gg.now.nowggsdkdemo.payments.billing.BillingProvider;

/**
 * Handles Ui specific to "vip_monthly" - subscription row
 */
public class VIPMonthlyDelegate extends UiManagingDelegate {
    public static final String SKU_ID = "monthlySub";

    public VIPMonthlyDelegate(BillingProvider billingProvider) {
        super(billingProvider);
    }

    @Override
    public @SkuType
    String getType() {
        return SkuType.SUBS;
    }

    @Override
    public void onBindViewHolder(SkuRowData data, RowViewHolder holder) {
        super.onBindViewHolder(data, holder);
        if (mBillingProvider.isVIPMonthlySubscribed()) {
            holder.button.setText(R.string.button_own);
            holder.button.setOnClickListener(null);
        } else {
            int textId = R.string.button_buy;
            holder.button.setText(textId);
        }
        holder.skuIcon.setImageResource(R.drawable.vip_icon);
    }

    @Override
    public void onButtonClicked(SkuRowData data) {
        mBillingProvider.getBillingManager().initiatePurchaseFlow(data.getSku(),
                data.getSkuType(), "");
    }
}
