package gg.now.nowggsdkdemo.rewardedAds;

import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.Toast;

import androidx.appcompat.app.AppCompatActivity;

import gg.now.ads.InterstitialAdStatusListener;
import gg.now.ads.NowGGAds;
import gg.now.ads.RewardedAdStatusListener;
import gg.now.ads.State;
import gg.now.nowggsdkdemo.R;

public class RewardedAdsActivity extends AppCompatActivity {

    public static final String TAG = "RewardsTest";

    public Button showAdButton;
    public Button showInterstitialAdButton;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main_rewarded_ads);
        showAdButton = findViewById(R.id.showAd);
        showInterstitialAdButton = findViewById(R.id.showInterstitialAd);

        /* IMPORTANT : Use this line, to test integration on Bluestacks, remove from prod/release apk */
        NowGGAds.enableDebugMode();

        NowGGAds.initialize(this, initializationStatus -> {
            Log.d(TAG, "onInitializationComplete: " + initializationStatus);

            if (initializationStatus.getState().equals(State.NOT_READY)) {
                Log.d(TAG, "onInitializationComplete: error");
                // retry creating rewardsClient
            }
        });

        showInterstitialAdButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                NowGGAds.showInterstitialAd(RewardedAdsActivity.this, new InterstitialAdStatusListener() {
                    @Override
                    public void onAdShownToUser() {
                        Log.d(TAG, "onAdShownToUser() called");
                        Toast.makeText(getBaseContext(), "onAdShownToUser() called", Toast.LENGTH_LONG).show();
                    }

                    @Override
                    public void onAdFailedToLoad(String s) {
                        Log.d(TAG, "onAdFailedToLoad() called with: s = [" + s + "]");
                        Toast.makeText(getBaseContext(), "onAdFailedToLoad() called with: s = [" + s + "]", Toast.LENGTH_LONG).show();
                    }

                    @Override
                    public void onAdDismissed() {
                        Log.d(TAG, "onAdDismissed() called");
                        Toast.makeText(getBaseContext(), "onAdDismissed() called", Toast.LENGTH_LONG).show();
                    }
                });
            }
        });

        showAdButton.setOnClickListener(view -> {

            NowGGAds.showRewardedAd(this, new RewardedAdStatusListener() {
                // Ad was shown on User's screen
                @Override
                public void onAdShownToUser() {
                    Toast.makeText(getBaseContext(), "Ad is displayed on the user's screen", Toast.LENGTH_LONG).show();
                    Log.d(TAG, "onAdShownToUser() called");
                }

                // Ad failed to load
                @Override
                public void onAdFailedToLoad(String s) {
                    Log.d(TAG, "onAdFailedToLoad() called with: s = [" + s + "]");
                    Toast.makeText(getBaseContext(), "Ad failed to load", Toast.LENGTH_SHORT).show();
                }

                //Ad was dismissed by user, continue with app operations.
                @Override
                public void onAdDismissed(boolean rewardEarned) {
                    Log.d(TAG, "adDismissed");
                    if (rewardEarned)
                        Toast.makeText(getBaseContext(), "Congrats, you earned a reward", Toast.LENGTH_LONG).show();
                    else
                        Toast.makeText(getBaseContext(), "Ad was dismissed - No reward this time!", Toast.LENGTH_LONG).show();
                }

                //User earned a reward
                @Override
                public void onUserEarnedReward() {
                    Log.d(TAG, "rewardEarned : ");
                    Toast.makeText(getBaseContext(), "Congrats, you earned a reward", Toast.LENGTH_LONG).show();
                }
            });
        });
    }
}