package gg.now.nowggsdkdemo.utility;

import android.app.Activity;
import android.os.Bundle;
import android.util.Log;
import android.widget.Toast;

import gg.now.nowggsdkdemo.R;
import gg.now.utility.sdk.UtilitySDK;

public class UtilityActivity extends Activity {

    private static final String TAG = UtilityActivity.class.getSimpleName();

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main_utility);

        findViewById(R.id.deviceType).setOnClickListener(view -> {
            Toast.makeText(UtilityActivity.this, UtilitySDK.getInstance().getDeviceType(UtilityActivity.this).toString(), Toast.LENGTH_LONG).show();
        });

        findViewById(R.id.openUrl).setOnClickListener(view -> {
            UtilitySDK.getInstance().openUrl("https://now.gg", UtilityActivity.this);
        });

        findViewById(R.id.isRunningOnNowgg).setOnClickListener(view -> {
            boolean isRunningOnNowgg = UtilitySDK.getInstance().isRunningOnNowGG(UtilityActivity.this);
            Log.d(TAG, "isRunningOnNowgg : " + isRunningOnNowgg);
            Toast.makeText(UtilityActivity.this, "isRunningOnNowgg : " + isRunningOnNowgg, Toast.LENGTH_LONG).show();
        });
    }
}