using System;
using UnityEditor;
using UnityEditor.Build.Reporting;
using UnityEngine;


namespace NowGG.Sdk
{
    public static class DependencyResolver
    {
        public static void RunEDMResolver()
        {
            var resolver = Type.GetType("GooglePlayServices.PlayServicesResolver, Google.JarResolver");

            if (resolver != null)
            {
                var method = resolver.GetMethod("ResolveSync", System.Reflection.BindingFlags.Static | System.Reflection.BindingFlags.Public);
                if (method != null)
                {
                    method.Invoke(null, new object[] { true });
                    Debug.Log("EDM4U dependency resolution completed.");
                }
                else
                {
                    Debug.LogWarning("ResolveSync method not found.");
                }
            }
            else
            {
                Debug.LogWarning("GooglePlayServices.PlayServicesResolver type not found.");
            }
        }
    }
    public class AndroidBuilder
    {

        public static void BuildWithSigning()
        {
            try
            {
                DependencyResolver.RunEDMResolver();
            }
            catch (Exception e)
            {
                Debug.Log("Error in resolving dependencies:: " + e.Message);
            }

            // Set keystore info (this can be stored securely in CI/CD)
            PlayerSettings.Android.keystoreName = "canny-snake.keystore";
            PlayerSettings.Android.keystorePass = "zingmpeg";
            PlayerSettings.Android.keyaliasName = "nowgg";
            PlayerSettings.Android.keyaliasPass = "zingmpeg";

            // Set output path
            string outputPath = "Builds/MainDemo.apk";

            // Build the player
            BuildReport report = BuildPipeline.BuildPlayer(
                new[] { "Assets/_Demo/Scenes/MainMenu.unity", "Assets/_Demo/Scenes/Login.unity", "Assets/_Demo/Scenes/Payments.unity", "Assets/_Demo/Scenes/Ads.unity", "Assets/_Demo/Scenes/Events.unity", "Assets/_Demo/Scenes/PaymentsQuick.unity" },
                outputPath,
                BuildTarget.Android,
                BuildOptions.None
            );

            if (report.summary.result != BuildResult.Succeeded)
            {
                Debug.LogError("Build failed!");
                EditorApplication.Exit(1);
            }
            else
            {
                Debug.Log("Build succeeded: " + outputPath);
            }

            EditorApplication.Exit(0);
        }

        public static void BuildMiTestVersionWithSigning()
        {
            try
            {
                DependencyResolver.RunEDMResolver();
            }
            catch (Exception e)
            {
                Debug.Log("Error in resolving dependencies:: " + e.Message);
            }
            
            string currentVersion = PlayerSettings.bundleVersion;
            // Set keystore info (this can be stored securely in CI/CD)
            PlayerSettings.Android.keystoreName = "canny-snake.keystore";
            PlayerSettings.Android.keystorePass = "zingmpeg";
            PlayerSettings.Android.keyaliasName = "nowgg";
            PlayerSettings.Android.keyaliasPass = "zingmpeg";
            PlayerSettings.bundleVersion = currentVersion + "_mitest";

            // Set output path
            string outputPath = "Builds/MainDemoMiTest.apk";

            // Build the player
            BuildReport report = BuildPipeline.BuildPlayer(
                new[] { "Assets/_Demo/Scenes/MainMenu.unity", "Assets/_Demo/Scenes/Login.unity", "Assets/_Demo/Scenes/Payments.unity", "Assets/_Demo/Scenes/Ads.unity", "Assets/_Demo/Scenes/Events.unity", "Assets/_Demo/Scenes/PaymentsQuick.unity" },
                outputPath,
                BuildTarget.Android,
                BuildOptions.None
            );

            if (report.summary.result != BuildResult.Succeeded)
            {
                Debug.LogError("Build failed!");
                EditorApplication.Exit(1);
            }
            else
            {
                Debug.Log("Build succeeded: " + outputPath);
            }
            PlayerSettings.bundleVersion = currentVersion; // Revert to original version
            Debug.Log("Reverted back to version: " + PlayerSettings.bundleVersion);

            EditorApplication.Exit(0);
        }
    }
}
