using System.Collections;
using System.Collections.Generic;
using UnityEngine;

namespace NowGG.Sdk
{
    public class NowGGUtilitySdkManager : MonoBehaviour
    {
        private static NowGGUtilitySdkManager instance;

        private AndroidJavaObject utilitySDK;
        public static NowGGUtilitySdkManager Instance
        {
            get
            {
                NowGGLogger.Log("Initialising NowGGUtilitySdkManager");
                if (instance == null)
                {
                    instance = new NowGGUtilitySdkManager();
                    AndroidJavaClass UtilitySDKClass = new AndroidJavaClass("gg.now.utility.sdk.UtilitySDK");
                    instance.utilitySDK = UtilitySDKClass.CallStatic<AndroidJavaObject>("getInstance");
                }
                return instance;
            }
        }
        public NowGGUtilitySdkManager()
        { }

        public bool IsRunningOnNowGG()
        {
            return utilitySDK.Call<bool>("isRunningOnNowGG",GetCurrentActivity());
        }

        public void OpenUrl(string url)
        {
            utilitySDK.Call("openUrl", url, GetCurrentActivity());
        } 

        public DeviceType GetDeviceType()
        {
            AndroidJavaObject activity = GetCurrentActivity();
            AndroidJavaObject context = activity.Call<AndroidJavaObject>("getApplicationContext");
            string deviceType = utilitySDK.Call<string>("getDeviceTypeAsString", context);
            return deviceType.ToLower() switch
            {
                "smartphone" => DeviceType.SMARTPHONE,
                "tablet" => DeviceType.TABLET,
                "desktop" => DeviceType.DESKTOP,
                _ => DeviceType.UNKNOWN,
            };
        }
        

        private AndroidJavaObject GetCurrentActivity()
        {
            AndroidJavaClass UnityPlayer = new AndroidJavaClass("com.unity3d.player.UnityPlayer");
            return UnityPlayer.GetStatic<AndroidJavaObject>("currentActivity");
        }
    }

    public enum DeviceType{
        SMARTPHONE,
        TABLET,
        DESKTOP,
        UNKNOWN
    }
}
