using System;
using System.Collections.Generic;
using UnityEngine;

namespace NowGG.Sdk
{
  public interface NowGGEventsListener
  {
    void OnNowGGEventReceivedFromBrowser(string name, string data);
  }
  public class NowGGEventsSdkManager : AndroidJavaProxy, NowGGEventsListener
  {
    private AndroidJavaObject nowGGAndroidJavaObj = new AndroidJavaObject("gg.now.sdk.events.unity.NowggEventUnitySDK");
    public Action<String, String> OnEventReceivedFromBrowser { get; set; }

    private static NowGGEventsSdkManager instance;
    public static NowGGEventsSdkManager Instance
    {
      get
      {
        NowGGLogger.Log("Initialising NowGGEventsSdkManager");
        if (instance == null)
        {
          instance = new NowGGEventsSdkManager();
        }

        return instance;
      }
    }
    public NowGGEventsSdkManager() : base("gg.now.sdk.events.unity.UnityEventsCallBack")
    { }
    public void InitializeEvents()
    {
      NowGGLogger.Log("Initialising Events method called");
#if !UNITY_EDITOR
            AndroidJavaClass player = new  AndroidJavaClass("com.unity3d.player.UnityPlayer");
            AndroidJavaObject activity = player.GetStatic<AndroidJavaObject>("currentActivity");
            nowGGAndroidJavaObj.Call("initialize",activity, this);
#else
      NowGGLogger.Log("Running in Unity Editor");
#endif
    }

    public void DestroyEventsReceiver()
    {
      NowGGLogger.Log("Destroy Events receiver method called");
#if !UNITY_EDITOR
            AndroidJavaClass player = new  AndroidJavaClass("com.unity3d.player.UnityPlayer");
            AndroidJavaObject activity = player.GetStatic<AndroidJavaObject>("currentActivity");
            
            nowGGAndroidJavaObj.Call("disposeReceiver",activity);
#else
      NowGGLogger.Log("Running in Unity Editor");
#endif
    }

    public void OnNowGGEventReceivedFromBrowser(string name, string data)
    {
      NowGGLogger.Log($"Received msg from browser {data}");
      if (OnEventReceivedFromBrowser != null)
        OnEventReceivedFromBrowser(name, data);
    }



#if UNITY_ANDROID

    private AndroidJavaObject GetCurrentActivity()
    {
      AndroidJavaClass UnityPlayer = new AndroidJavaClass("com.unity3d.player.UnityPlayer");
      return UnityPlayer.GetStatic<AndroidJavaObject>("currentActivity");
    }

    private AndroidJavaObject GetExtras()
    {
      AndroidJavaObject currentActivity = GetCurrentActivity();
      AndroidJavaObject intent = currentActivity.Call<AndroidJavaObject>("getIntent");
      return intent.Call<AndroidJavaObject>("getExtras");
    }

    private void SendEvent(AndroidJavaObject evt)
    {
      AndroidJavaObject currentActivity = GetCurrentActivity();
      AndroidJavaObject component = new AndroidJavaObject("android.content.ComponentName", "gg.now.player", "gg.now.player.unitysdk.UnitySdkMessageService");
      evt.Call<AndroidJavaObject>("setComponent", component);
      currentActivity.Call<AndroidJavaObject>("startService", evt);
    }

    // can be used to configure debug mode on now.gg player
    public void ConfigureDebug(bool showFps, bool showPointer, bool showTouchPoints)
    {
      AndroidJavaObject evt = new AndroidJavaObject("android.content.Intent");
      evt.Call<AndroidJavaObject>("setAction", "gg.now.SET_DEBUG_INFO");
      evt.Call<AndroidJavaObject>("putExtra", "showFps", showFps);
      evt.Call<AndroidJavaObject>("putExtra", "showPointer", showPointer);
      evt.Call<AndroidJavaObject>("putExtra", "showTouchPoints", showTouchPoints);
      SendEvent(evt);
    }

    // sends an event to the browser
    public void SendEventToBrowser(string eventName, string eventData)
    {
      AndroidJavaObject evt = new AndroidJavaObject("android.content.Intent");
      evt.Call<AndroidJavaObject>("setAction", "gg.now.PUBLISH_EVENT_TO_GAME_WEBSITE");
      evt.Call<AndroidJavaObject>("putExtra", "eventName", eventName);
      evt.Call<AndroidJavaObject>("putExtra", "eventData", eventData);
      SendEvent(evt);
    }

    public void SetIdleTimeout(int seconds)
    {
      NowGGLogger.Log("Set idle timeout method called");
      AndroidJavaObject evt = new AndroidJavaObject("android.content.Intent");
      evt.Call<AndroidJavaObject>("setAction", "gg.now.SET_IDLE_TIMEOUT");
      evt.Call<AndroidJavaObject>("putExtra", "idleTimeoutInSecs", seconds);
      SendEvent(evt);
    }

    // opens a url in new window
    public void OpenURL(string url)
    {
      NowGGLogger.Log("Opening url: " + url);
      AndroidJavaObject evt = new AndroidJavaObject("android.content.Intent");
      evt.Call<AndroidJavaObject>("setAction", "gg.now.OPEN_URL");
      evt.Call<AndroidJavaObject>("putExtra", "url", url);
      SendEvent(evt);
    }

    //returns value of a property defined in the iframes appLaunchData, if the property is not found returns an empty string
    public string GetAppLaunchDataProperty(string propertyName)
    {
      NowGGLogger.Log("GetAppLaunchDataProperty called");
      string s = string.Empty;
      AndroidJavaObject extras = GetExtras();
      if (extras != null)
      {
        s = extras.Call<string>("getString", propertyName);
      }
      return s;
    }

    //returns a Dictionary<string, string> with all params defined in the iframes appLaunchData property
    public Dictionary<string, string> GetAppLaunchDataDictionary()
    {
      Dictionary<string, string> dict = new Dictionary<string, string>();
      AndroidJavaObject extras = GetExtras();
      if (extras != null)
      {
        // Get the key set as an array of objects
        AndroidJavaObject keySet = extras.Call<AndroidJavaObject>("keySet");
        string[] keys = keySet.Call<string[]>("toArray");
        foreach (string key in keys)
        {
          // Retrieve value for each key
          string value = extras.Call<string>("getString", key);
          dict[key] = value;
        }
      }
      return dict;
    }
#endif
  }
}