using System;
using System.Collections.Generic;
using System.Linq;
using NowGG.Sdk;
using UnityEngine;
using UnityEngine.Purchasing;

public class NowGGSubscriptionManager
{
    private readonly string receipt;

    private readonly string productId;


    // public static void UpdateSubscription(Product newProduct, Product oldProduct, string developerPayload, Action<Product, string> appleStore, Action<string, string> googleStore)
    // {
    //     if (oldProduct.receipt == null)
    //     {
    //         Debug.LogError("The product has not been purchased, a subscription can only be upgrade/downgrade when has already been purchased");
    //         return;
    //     }

    //     Dictionary<string, object> dictionary = (Dictionary<string, object>)MiniJson.JsonDecode(oldProduct.receipt);
    //     if (dictionary == null || !dictionary.ContainsKey("Store") || !dictionary.ContainsKey("Payload"))
    //     {
    //         Debug.LogWarning("The product receipt does not contain enough information");
    //         return;
    //     }

    //     string text = (string)dictionary["Store"];
    //     if ((string)dictionary["Payload"] == null)
    //     {
    //         return;
    //     }

    //     switch (text)
    //     {
    //         case "GooglePlay":
    //             {
    //                 SubscriptionManager subscriptionManager = new SubscriptionManager(oldProduct, null);
    //                 SubscriptionInfo subscriptionInfo;
    //                 try
    //                 {
    //                     subscriptionInfo = subscriptionManager.getSubscriptionInfo();
    //                 }
    //                 catch (Exception message)
    //                 {
    //                     Debug.unityLogger.LogError("Error: the product that will be updated does not have a valid receipt", message);
    //                     break;
    //                 }

    //                 string storeSpecificId = newProduct.definition.storeSpecificId;
    //                 googleStore(subscriptionInfo.getSubscriptionInfoJsonString(), storeSpecificId);
    //                 break;
    //             }
    //         case "AppleAppStore":
    //         case "MacAppStore":
    //             appleStore(newProduct, developerPayload);
    //             break;
    //         default:
    //             Debug.LogWarning("This store does not support update subscriptions");
    //             break;
    //     }
    // }


    public NowGGSubscriptionManager(UnityEngine.Purchasing.Product product)
    {
        receipt = product.receipt;
        productId = product.definition.storeSpecificId;
    }

    public NowGGSubscriptionManager(string receipt, string id)
    {
        this.receipt = receipt;
        productId = id;
    }

    public SubscriptionInfo getSubscriptionInfo()
    {
        if (receipt != null)
        {
            Dictionary<string, object> source = (Dictionary<string, object>)MiniJson.JsonDecode(receipt);
            source.TryGetValue("Payload", out var payloadString);
            string payloadString2 = (string)payloadString;
            NowGGLogger.Log($"{payloadString2} {payloadString2.GetType()}");
            Dictionary<string, object> payload = (Dictionary<string, object>)MiniJson.JsonDecode(payloadString2);
            try
            {
                payload.TryGetValue("skuDetails", out var skuDetails);
                bool purchaseHistorySupported = false;
                bool isAutoRenewing = false;
                bool gotAutoRenewing = payload.TryGetValue("isAutoRenewing", out var isAutoRenewingFromReceipt);

                if (gotAutoRenewing)
                {
                    isAutoRenewing = (bool)isAutoRenewingFromReceipt;
                }

                DateTime dateTime = new DateTime(1970, 1, 1, 0, 0, 0, DateTimeKind.Utc);
                object value3;
                bool num2 = payload.TryGetValue("purchaseTime", out value3);
                long num3 = 0L;
                if (num2)
                {
                    num3 = (long)value3;
                }

                DateTime purchaseDate = dateTime.AddMilliseconds(num3);
                bool isFreeTrial = false;
                bool hasIntroductoryPriceTrial = false;
                string updateMetadata = null;

                return new SubscriptionInfo((string)skuDetails, isAutoRenewing, purchaseDate, isFreeTrial, hasIntroductoryPriceTrial, purchaseHistorySupported, updateMetadata);
            }
            catch (Exception e)
            {
                NowGGLogger.Log($"Error in getSubscription Info {e}");
            }

        }

        throw new NullReceiptException();
    }

}

