using System;
using System.Collections.Generic;
using UnityEngine;

namespace NowGG.Sdk
{

    public interface NowGGLoginListener
    {
        void OnNowGGLoginSuccess(string email, string token, string hostUrl);
        void OnNowGGLoginFailed(int code, string errorMsg);
    }

    public class NowGGLoginSdkManager : AndroidJavaProxy, NowGGLoginListener
    {
      AndroidJavaObject nowGGLoginAndroidJavaObj;
      public Action<string, string, string> OnLoginSuccess { get; set; }
      public Action<int, string> OnLoginFailed { get; set; }


      public NowGGLoginSdkManager() : base("gg.now.sdk.common.UnityLoginCallBack")
      {
      }
      private static NowGGLoginSdkManager instance;
      public static NowGGLoginSdkManager Instance
      {
          get
          {
              NowGGLogger.Log("Initialising NowGGLoginSdkManager");
              if (instance == null)
              {
                  instance = new NowGGLoginSdkManager();
              }
              return instance;
          }
      }

      public void Login(string clientId, string idToken = "id_token")
      {
  #if !UNITY_EDITOR

          if (nowGGLoginAndroidJavaObj == null)
              nowGGLoginAndroidJavaObj = new AndroidJavaObject("gg.now.sdk.NowggLoginUnitySDK");
          AndroidJavaClass player = new  AndroidJavaClass("com.unity3d.player.UnityPlayer");
          AndroidJavaObject activity = player.GetStatic<AndroidJavaObject>("currentActivity");
          nowGGLoginAndroidJavaObj.Call("login", activity, this, clientId, idToken);
  #else
          OnNowGGLoginSuccess("a@b.com", "test_token", "test.com");
  #endif
      }

      public void OnNowGGLoginSuccess(string email, string token, string hostUrl)
      {
          NowGGLogger.Log($"OnNowGGLoginSuccess called with email: {email}, token: {token}, hostUrl: {hostUrl}");
          if (OnLoginSuccess != null)
          {
              OnLoginSuccess(email, token, hostUrl);
              NowGGLogger.Log("OnLoginSuccess callback invoked.");
          }
          else
          {
              NowGGLogger.Log("OnLoginSuccess callback is null.");
          }
      }

      public void OnNowGGLoginFailed(int code, string errorMsg)
      {
          NowGGLogger.Log($"OnNowGGLoginFailed called with code: {code}, errorMsg: {errorMsg}");
          if (OnLoginFailed != null)
          {
              OnLoginFailed(code, errorMsg);
              NowGGLogger.Log("OnLoginFailed callback invoked.");
          }
          else
          {
              NowGGLogger.Log("OnLoginFailed callback is null.");
          }
      }

      public void AddNowGGAccount()
      {
          NowGGLogger.Log("AddNowGGAccount called.");
          if (nowGGLoginAndroidJavaObj != null)
          {
              nowGGLoginAndroidJavaObj.Call("addAccount");
              NowGGLogger.Log("addAccount method called on AndroidJavaObject.");
          }
          else
          {
              NowGGLogger.Log("nowGGLoginAndroidJavaObj is null. Please call NowGG login function before calling AddNowGGAccount function.");
          }
      }

    }
}