using NowGG.Sdk;
using TMPro;
using UnityEngine;

public class AdsHandler : MonoBehaviour
{
    public TMP_Text TextStatus;

    private void Start()
    {
        NowGGAdsManager.Instance.OnInitSuccess += OnInitSuccess;
        NowGGAdsManager.Instance.OnInitFailed += OnInitFailed;
        NowGGAdsManager.Instance.OnNowGGRewardedAdDismissed += OnAdDismissed;
        NowGGAdsManager.Instance.OnNowGGRewardedAdFailedToLoad += OnAdFailedToLoad;
        NowGGAdsManager.Instance.OnNowGGRewardedAdShownToUser += OnAdShownToUser;
        NowGGAdsManager.Instance.OnUserEarnedReward += OnUserEarnedReward;

        NowGGAdsManager.Instance.Initialize();
    }

    public void ShowAd()
    {
        Utils.Log("Showing rewraded ad");
        NowGGAdsManager.Instance.ShowRewardedAd();
    }

    private void OnInitSuccess()
    {
        Utils.Log("OnInitSuccess");
        TextStatus.text = "Ads initialized";
    }

    private void OnInitFailed(string error)
    {
        Utils.Log("OnInitFailed. Error: " + error);
        TextStatus.text = "Ads initialization failed. Error: " + error;
    }

    private void OnAdShownToUser()
    {
        Utils.Log("OnAdShownToUser");
        TextStatus.text = "Ad shown to user";
    }

    private void OnAdFailedToLoad(string error)
    {
        Utils.Log("OnAdFailedToLoad. Error: " + error);
        TextStatus.text = "Ad failed to load. Error: " + error;
    }

    private void OnAdDismissed(bool rewardEarned)
    {
        Utils.Log("OnAdDismissed. User earned reward: " + rewardEarned);
        TextStatus.text = "Ad dismissed by user. Reward earned: " + rewardEarned;
    }

    private void OnUserEarnedReward()
    {
        Utils.Log("OnUserEarnedReward");
        TextStatus.text = "User earned reward";
    }

    public void BtnBackClicked()
    {
        Utils.LoadScene(Constants.SceneName.MainMenu);
    }

    public void BtnShowRewardedAdClicked()
    {
        ShowAd();
    }
}
