using NowGG.Sdk;
using System.Collections.Generic;
using TMPro;
using UnityEngine;

public class EventsHandler : MonoBehaviour
{
    public TMP_Text TextStatus;

    public void BtnBackClicked()
    {
        Utils.LoadScene(Constants.SceneName.MainMenu);
    }

    public void BtnOpenUrlClicked()
    {
        string url = "https://now.gg";
        NowGGEventsSdkManager.Instance.OpenURL(url);
        TextStatus.text = "Opened https://now.gg";
    }

    public void BtnSendEventClicked()
    {
        string eventName = "test-event";
        string eventData = "test-data";

        NowGGEventsSdkManager.Instance.SendEventToBrowser(eventName, eventData);

        TextStatus.text = "Test data sent to hosting web page";
    }

    public void BtnShowAppLaunchData()
    {
        string data = "";
        Dictionary<string, string> appLaunchData = NowGGEventsSdkManager.Instance.GetAppLaunchDataDictionary();
        foreach (string key in appLaunchData.Keys)
        {
            data += $"{key}={appLaunchData[key]},";
        }

        TextStatus.text = "Launch data: " + data;
    }
}
