﻿using UnityEngine;
using System.Collections;
using System.Collections.Generic;
using UnityEngine.Networking;
using System;
using System.Text;
using NowGG.Sdk;
using UnityEngine.Purchasing;

public class ServerVerificationNew : MonoBehaviour
{

    public static ServerVerificationNew mInstance;

    [System.Serializable]
    public class ServerVerificationJSON
    {
        public bool success;
        public string code;
        public string codeMsg;
        [SerializeField] private Data data;
        public Data serverResponsedata { get { return data; } }
        
    }

    [System.Serializable]
    public class Data
    {
        public int consumptionState;
        public string developerPayload;
        public int purchaseState;
        public string purchaseTime;
        public string purchaseId;
        public int acknowledgeState;
        public int quantity;
    }

    private void Awake()
    {
        Debug.Log("ServerVerificationNew Start called");
        mInstance = this;
    }


    public void purchaseServerVerification(PurchaseEventArgs purchasedProduct, Action onSuccess)
    {
        StartCoroutine(ServerVerificationAPI(purchasedProduct, onSuccess));   
    }

    public IEnumerator ServerVerificationAPI(PurchaseEventArgs purchasedProductArgs, Action onSuccess)
    {
        Debug.Log("ServerVerificationAPI from unity");
        string serverVerificationJson = NowGGPaymentsSdkManager.Instance.GetServerVerificationJSON(purchasedProductArgs);   
        Debug.Log("JSONString from unity " + serverVerificationJson);
        string env = NowGG.Sdk.NowGGPaymentsSdkManager.GetEnvironmentName();
        string url = "https://us-central1-now-gg-payments.cloudfunctions.net/nowgg-demo-payments-backend-prod/multi-store/verify";
        if (!env.Equals("prod"))
        {
            url = "https://us-central1-now-gg-payments.cloudfunctions.net/nowgg-demo-payments-backend/multi-store/verify";
        }
        var unityWebRequest = UnityWebRequest.PostWwwForm(url, serverVerificationJson);
        byte[] bodyRaw = Encoding.UTF8.GetBytes(serverVerificationJson);
        unityWebRequest.uploadHandler = (UploadHandler)new UploadHandlerRaw(bodyRaw);
        unityWebRequest.downloadHandler = (DownloadHandler)new DownloadHandlerBuffer();
        unityWebRequest.SetRequestHeader("Content-Type", "application/json");
        Debug.Log("serverVerification from unity");
        yield return unityWebRequest.SendWebRequest();

        if (unityWebRequest.result != UnityWebRequest.Result.Success)
        {
            Debug.LogError(unityWebRequest.error);
        } else
        {
            Debug.Log("serverVerification: response: " + unityWebRequest.downloadHandler.text);
            string response = unityWebRequest.downloadHandler.text;
            ServerVerificationJSON verificationJSON =  JsonUtility.FromJson<ServerVerificationJSON>(response);
            if (verificationJSON.success)
            {
                Debug.Log("serverVerification : success " + verificationJSON.ToString());
                string payloadString = (string)(    (Dictionary<string, object>)MiniJson.JsonDecode(purchasedProductArgs.purchasedProduct.receipt))["Payload"];
                var payloadJson = (Dictionary<string, object>)MiniJson.JsonDecode(payloadString);
                string productId = (string)payloadJson["productId"];
                string purchaseToken = (string)payloadJson["purchaseToken"];
                onSuccess.Invoke();
                NowGG.Sdk.NowGGPaymentsSdkManager.Instance.ConfirmPendingPurchase(purchaseToken, NowGG.Sdk.ProductType.Consumable);
            }
            else
            {
                Debug.Log("serverVerification : failed " + verificationJSON.ToString());
            }
        }
    }
}
